using System;
using System.Windows.Forms;
using System.Security.Permissions;
using aXes;


public class Form1 : Form
{
    private String protocol = "http";
    private String host     = "vlfteam:8080";
    private String projectfolder = "aExternalHosting";

    private aXes.ExternalHost oaXes = new aXes.ExternalHost();

    private Panel panel1;

    private Button button_open;
    private Button button_close;  
    private Button button_enterkey;
    private Button button_F3key;
    private Button button_F12key;
    private Button button_setField;
    private Button button_getField;
    private Button button_setUSERAREA;
    private Button button_getUSERAREA;
    private TextBox FieldValue;
    private TextBox FieldSubfileIndex;
    private TextBox FieldName;
    private Label textMessageInfo;
    
    // ================================================================
    // Constructor
    // ================================================================
    

    public Form1()
    {

        this.Height = 700;
        this.Width = 1000;

        // Hook up to listen for AXES forms arriving and departing   

        this.oaXes.ScreenArrive += this.ScreenArrived;
        this.oaXes.ScreenDepart += this.ScreenDeparted; 
        
        // Create the example screen 

        this.panel1 = new System.Windows.Forms.Panel();
        this.button_open     = new System.Windows.Forms.Button();
        this.button_close    = new System.Windows.Forms.Button();
        this.button_enterkey = new System.Windows.Forms.Button();
        this.button_F3key = new System.Windows.Forms.Button();
        this.button_F12key = new System.Windows.Forms.Button();
        this.button_setField = new System.Windows.Forms.Button();
        this.button_getField = new System.Windows.Forms.Button();
        this.button_setUSERAREA = new System.Windows.Forms.Button();
        this.button_getUSERAREA = new System.Windows.Forms.Button();
        this.FieldName = new System.Windows.Forms.TextBox();
        this.FieldSubfileIndex = new System.Windows.Forms.TextBox();
        this.FieldValue = new System.Windows.Forms.TextBox();
        this.textMessageInfo = new Label();
        this.textMessageInfo.BackColor = System.Drawing.Color.Azure; 
        
        // 
        // set up panel 1
        // 
        
        this.panel1.Controls.Add(this.FieldValue);
        this.panel1.Controls.Add(this.FieldSubfileIndex);
        this.panel1.Controls.Add(this.FieldName);
        this.panel1.Controls.Add(this.button_open);
        this.panel1.Controls.Add(this.button_close);
        this.panel1.Controls.Add(this.button_enterkey);
        this.panel1.Controls.Add(this.button_F3key);
        this.panel1.Controls.Add(this.button_F12key);
        this.panel1.Controls.Add(this.button_setField);
        this.panel1.Controls.Add(this.button_getField);
        this.panel1.Controls.Add(this.button_setUSERAREA);
        this.panel1.Controls.Add(this.button_getUSERAREA);
        this.panel1.Name = "panel1";
        this.panel1.Size = new System.Drawing.Size(445, 220);
        

        // 
        // button_open
        // 

        this.button_open.Location = new System.Drawing.Point(15, 14);
        this.button_open.Size = new System.Drawing.Size(128, 23);
        this.button_open.Text = "Open aXes Session";
        this.button_open.UseVisualStyleBackColor = true;
        button_open.Click += new EventHandler(button_open_Click);
        
        // 
        // button_close
        // 

        this.button_close.Location = new System.Drawing.Point(15, 44);
        this.button_close.Size = new System.Drawing.Size(128, 23);
        this.button_close.Text = "Close aXes Session";
        this.button_close.UseVisualStyleBackColor = true;
        button_close.Click += new EventHandler(button_close_Click);

        // 
        // button_enterkey
        // 

        this.button_enterkey.Location = new System.Drawing.Point(15, 74);
        this.button_enterkey.Size = new System.Drawing.Size(128, 23);
        this.button_enterkey.Text = "Send Enter Key";
        this.button_enterkey.UseVisualStyleBackColor = true;
        button_enterkey.Click += new EventHandler(button_enterkey_Click);

        // 
        // button_enterkey
        // 

        this.button_F3key.Location = new System.Drawing.Point(145, 74);
        this.button_F3key.Size = new System.Drawing.Size(128, 23);
        this.button_F3key.Text = "Send F3 Key";
        this.button_F3key.UseVisualStyleBackColor = true;
        button_F3key.Click += new EventHandler(button_F3key_Click);

        // 
        // button_F12key
        // 

        this.button_F12key.Location = new System.Drawing.Point(275, 74);
        this.button_F12key.Size = new System.Drawing.Size(128, 23);
        this.button_F12key.Text = "Send F12 Key";
        this.button_F12key.UseVisualStyleBackColor = true;
        button_F12key.Click += new EventHandler(button_F12key_Click);


        // 
        // button_setField
        // 

        this.button_setField.Location = new System.Drawing.Point(15,104);
        this.button_setField.Size = new System.Drawing.Size(128, 23);
        this.button_setField.Text = "Set a Field Value";
        this.button_setField.UseVisualStyleBackColor = true;
        button_setField.Click += new EventHandler(button_setField_Click);
        
        // 
        // button_getField
        // 

        this.button_getField.Location = new System.Drawing.Point(15,134);
        this.button_getField.Size = new System.Drawing.Size(128, 23);
        this.button_getField.Text = "Get a Field Value";
        this.button_getField.UseVisualStyleBackColor = true;
        button_getField.Click += new EventHandler(button_getField_Click);

        // 
        // button_getUSERAREA
        // 

        this.button_getUSERAREA.Location = new System.Drawing.Point(15, 164);
        this.button_getUSERAREA.Size = new System.Drawing.Size(128, 23);
        this.button_getUSERAREA.Text = "Get a USERAREA";
        this.button_getUSERAREA.UseVisualStyleBackColor = true;
        button_getUSERAREA.Click += new EventHandler(button_getUSERAREA_Click);

        // 
        // button_setUSERAREA
        // 

        this.button_setUSERAREA.Location = new System.Drawing.Point(15, 194);
        this.button_setUSERAREA.Size = new System.Drawing.Size(128, 23);
        this.button_setUSERAREA.Text = "Set a USERAREA";
        this.button_setUSERAREA.UseVisualStyleBackColor = true;
        button_setUSERAREA.Click += new EventHandler(button_setUSERAREA_Click);

        // 
        // FieldName
        // 

        this.FieldName.Location = new System.Drawing.Point(149, 104);
        this.FieldName.Size = new System.Drawing.Size(116, 20);
        this.FieldName.Text = "Field name";

        // 
        // FieldSubfileIndex
        // 

        this.FieldSubfileIndex.Location = new System.Drawing.Point(272, 104);
        this.FieldSubfileIndex.Size = new System.Drawing.Size(31, 20);
        this.FieldSubfileIndex.Text = "0";

        // 
        // FieldValue
        // 

        this.FieldValue.Location = new System.Drawing.Point(310, 104);
        this.FieldValue.Name = "FieldValue";
        this.FieldValue.Size = new System.Drawing.Size(247, 20);
        this.FieldValue.Text = "Field Value";
        
        // 
        // Form1
        // 


        panel1.Dock          = DockStyle.Top;
        textMessageInfo.Dock = DockStyle.Top;
        oaXes.Dock           = DockStyle.Fill;
        
        Controls.Add(oaXes);
        Controls.Add(textMessageInfo);
        Controls.Add(panel1);
        
    }

    // ================================================================
    // Handle arrival of an aXes screen  
    // ================================================================

    private void ScreenArrived(object sender, ScreenArriveEventArgs evt)
    {
        ScreenInfo screen = evt.Screen;
        if (screen.Name == "") textMessageInfo.Text = "The screen that has just arrived has no name."; 
        else                   textMessageInfo.Text = "A screen named " + screen.Name + " has arrived";     
    }

    // ================================================================
    // Handle the departure of an aXes screen  
    // ================================================================

    private void ScreenDeparted(object sender, ScreenDepartEventArgs evt)
    {
        ScreenInfo screen = evt.Screen;
        if (screen.Name == "") textMessageInfo.Text = "The screen that has just departed has no name.";
        else textMessageInfo.Text = "A screen named " + screen.Name + " has just departed";
    }
        
    // ================================================================
    // Open an Axes session 
    // ================================================================

    private void button_open_Click(object sender, EventArgs e)
    {
        // Set last parameter to true for aXes-TS2 or false for aXes-TS

        oaXes.Open(this.protocol, this.host, this.projectfolder, false, true);
    }

    // ================================================================
    // Close an aXes session
    // ================================================================

    private void button_close_Click(object sender, EventArgs e)
    {
        oaXes.Close();
    }
    
    // ================================================================
    // send enter key 
    // ================================================================

    private void button_enterkey_Click(object sender, EventArgs e)
    {
        oaXes.SendKey(Key.Enter); 
    }

    // ================================================================
    // send F3 key 
    // ================================================================

    private void button_F3key_Click(object sender, EventArgs e)
    {
        oaXes.SendKey(Key.F3);
    }

    // ================================================================
    // send F12 key 
    // ================================================================

    private void button_F12key_Click(object sender, EventArgs e)
    {
        oaXes.SendKey(Key.F12);
    }
    
    // ================================================================
    // Set a field on the current aXes screen 
    // ================================================================

    private void button_setField_Click(object sender, EventArgs e)
    {
        int       index = Convert.ToInt32(FieldSubfileIndex.Text);
        FieldInfo oField   = oaXes.Fields(FieldName.Text,index);

        if (oField == null)
        {
            textMessageInfo.Text = "Field named " + FieldName.Text + " with index " + 
                index.ToString() + " not found on current screen.";
        }
        else
        {
            oField.SetValue(FieldValue.Text);
            textMessageInfo.Text = "Field named " + FieldName.Text + " with index " + 
                index.ToString() + " changed to " + FieldValue.Text;
        }
                
    }
    
    // ================================================================
    // Get a field from the current aXes screen 
    // ================================================================

    private void button_getField_Click(object sender, EventArgs e)
    {
        int index = Convert.ToInt32(FieldSubfileIndex.Text);
        FieldInfo oField = oaXes.Fields(FieldName.Text, index);


        if (oField == null)
        {
            textMessageInfo.Text = "Field named " + FieldName.Text + " with index " +
                index.ToString() + " not found on current screen.";
        }
        else
        {
            FieldValue.Text = oField.GetValue();
            textMessageInfo.Text = "Field named " + FieldName.Text + " with index " + 
                index.ToString() + " contains value " + FieldValue.Text;
        }

    }

    // ================================================================
    // set a named value into the shared USERAREA  
    // ================================================================

    private void button_setUSERAREA_Click(object sender, EventArgs e)
    {
       int index = Convert.ToInt32(FieldSubfileIndex.Text);

       String compositename = FieldName.Text;

       if (index > 0) compositename += "_" + index.ToString();

       oaXes.UserArea.SetValue(compositename, FieldValue.Text);

       textMessageInfo.Text = "The UserArea property named " + compositename +
                " has been set to value " + FieldValue.Text;    
    }
    // ================================================================
    // Get a named value into the shared USERAREA  
    // ================================================================

    private void button_getUSERAREA_Click(object sender, EventArgs e)
    {

       int index = Convert.ToInt32(FieldSubfileIndex.Text);

       String compositename = FieldName.Text;

       if (index > 0) compositename += "_" + index.ToString();

       FieldValue.Text = oaXes.UserArea.GetValue(compositename);

       textMessageInfo.Text = "The UserArea property named " + FieldName.Text +
              " was found to contain " + FieldValue.Text;
    }
       
    // ================================================================
    // Run the application
    // ================================================================
    
    static class Program
    {
        [STAThread]
        static void Main()
        {
            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);
            Application.Run(new Form1());
        }
    }

}
